package parser;

/**
 * Id token class.
 */
public class IdToken extends AToken {
    /**
     * Interface for a visitor to visit a id token.
     */
    public static interface IIdVisitor extends ITokVisitor {
        /**
         * Case for a id token.
         *
         * @param host  id token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object idCase(IdToken host, Object param);
    }

    /**
     * Constructor for a id token.
     *
     * @param lexeme id lexeme
     */
    public IdToken(String lexeme) {
        super(lexeme);
    }

    /**
     * Execute the id case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof IIdVisitor) ? ((IIdVisitor) algo).idCase(this, param) : algo.defaultCase(this, param);
    }
}

